#include <iostream>
#include <vector>

void anotherFunction(int value);

int main(int argc, char** argv) {
	std::cout << "This prints some text to the command line!" << std::endl;

	getchar(); std::cout << "----------" << std::endl;

	




	// There are a fair number of integer data types
	char charVariable = 3;
	short shortVariable = 1;
	int intVariable = 4;
	long longVariable = 1;
	long long longlongVariable = 5;

	// As well as unsigned versions
	unsigned char ucharVariable = 9;
	unsigned short ushortVariable = 2;
	unsigned int uintVariable = 6;
	unsigned long ulongVariable = 5;
	unsigned long long ulonglongVariable = 3;

	// On some systems, long may be 4 bytes long. Long long is guaranteed to _at least_ be a 64 bit value.

	std::cout << "char: " << sizeof(charVariable) << ", " << sizeof(ucharVariable) << std::endl;
	std::cout << "short: " << sizeof(shortVariable) << ", " << sizeof(ushortVariable) << std::endl;
	std::cout << "int: " << sizeof(intVariable) << ", " << sizeof(uintVariable) << std::endl;
	std::cout << "long: " << sizeof(longVariable) << ", " << sizeof(ulongVariable) << std::endl;
	std::cout << "long long: " << sizeof(longlongVariable) << ", " << sizeof(ulonglongVariable) << std::endl;

	getchar(); std::cout << "----------" << std::endl;






	// Similarly, there are a number of floating point types

	float floatValue = 0.04f;
	double doubleValue = 0.04;
	long double longDoubleValue = 0.04;

	std::cout << "floatValue: " << sizeof(floatValue) << std::endl;
	std::cout << "doubleValue: " << sizeof(doubleValue) <<  std::endl;
	std::cout << "longDoubleValue: " << sizeof(longDoubleValue) << std::endl;

	getchar(); std::cout << "----------" << std::endl;











	float arbitraryFloat = 5.6;
	int convertedInteger = (int) arbitraryFloat;

	std::cout << "Cast integer: " << convertedInteger << std::endl;

	getchar(); std::cout << "----------" << std::endl;











	// Deviation from Java!

	int a;
	int b = 0;

	std::cout << "a: " << a << std::endl;
	std::cout << "b: " << b << std::endl;

	getchar(); std::cout << "----------" << std::endl;





	

	// Let's create another function!

	int parameter = 5;
	anotherFunction(parameter);


	return 0;
}

typedef struct Point {
	float x;
	float y;
	float z;
} Point;

void anotherFunction(int value) {
	std::cout << value << std::endl;
	getchar(); std::cout << "----------" << std::endl;







	Point point;
	point.x = 3;
	point.y = 1;
	point.z = 4;

	std::cout << point.x << ", " << point.y << ", " << point.z << std::endl;
	getchar(); std::cout << "----------" << std::endl;






	int pointed = 5;
	int* pointer = &pointed;
	std::cout << "Pointed: " << *pointer << std::endl;

	*pointer = 6;
	std::cout << "Pointed modified: " << pointed << std::endl;

	pointed = 10;
	std::cout << "Pointed modified: " << *pointer << std::endl;

	int* nullpointer = nullptr;
	// *nullPointer = 5;

	Point* pointerToPoint = &point;

	std::cout << pointerToPoint->x << ", " << pointerToPoint->y << ", " << pointerToPoint->z << std::endl;

	getchar(); std::cout << "----------" << std::endl;








	// This is a scope
	{

	}

	// These are nested scopes
	{
		{

		}
	}


	if(value > 3) {
		for(int i = 0; i < 10; i++) {
			int j = 0;

			while(j < 10) {
				j++;
				std::cout << "x";
			}
		}
		std::cout << std::endl;
	}

	getchar(); std::cout << "----------" << std::endl;

	// +-------------+---------------------+--------+
	// |    stack    |                     |  heap  |
	// +-------------+---------------------+--------+

	{
		int a;
		int b;
		int c;

		{
			int d;
			int e;

			{
				int f;
				int g;
			}
		}
	}

	Point* heapPoint = new Point;

	heapPoint->x = 42;
	std::cout << heapPoint->x;

	delete heapPoint;

	getchar(); std::cout << "----------" << std::endl;







	// Notice: only a pointer, no length!

	Point* array = new Point[500];

	for(int i = 0; i < 500; i++) {
		// Array indexing does dereferencing for you
		array[i].x = 5;
	}

	delete[] array;








	const int elementCount = 500;








	std::vector<int> someVec;

	someVec.push_back(5);

	std::cout << "Vector contains: " << someVec.at(0) << std::endl;

	someVec.at(0) = 3;

	std::cout << "Vector contains: " << someVec.at(0) << std::endl;	

	std::cout << "Vector length is: " << someVec.size() << std::endl;

	someVec.erase(someVec.begin() + 0);

	std::cout << "Vector length is: " << someVec.size() << std::endl;

	someVec.reserve(500);

	std::cout << "Reserved vector length is: " << someVec.size() << std::endl;

	someVec.resize(1000);

	std::cout << "Resized vector length is: " << someVec.size() << std::endl;

	getchar(); std::cout << "----------" << std::endl;





}