#include <iostream>
#include <cmath>

int main(int argc, char** argv) {

	const unsigned long long itemCount = 500000000;

	unsigned long long* integers = new unsigned long long[itemCount];
	double* angles = new double[itemCount];

	#pragma omp parallel for
	for(int i = 0; i < itemCount; i++) {
		integers[i] = i;
	}

	#pragma omp parallel for
	for(unsigned int i = 0; i < itemCount; i++) {
		unsigned int remainder = integers[i] % 360;
		double angleRadians = (double(remainder) / 360.0) * M_PI;
		double cosine = std::cos(angleRadians);
		angles[i] = cosine;
	}

	return 0;
}