#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <mpi.h>


int
main ( int argc, char **argv )
{
    int rank, size;
    MPI_Init ( &argc, &argv );
    MPI_Comm_rank ( MPI_COMM_WORLD, &rank );
    MPI_Comm_size ( MPI_COMM_WORLD, &size );

    /* Find maximum of P numbers */

    // Everyone pulls one number out of a hat
    srand(time(NULL)+rank);
    int number = rand();
    int max = 0;

    // Find the maximum with a collective operation
    MPI_Allreduce ( &number, &max, 1, MPI_INT, MPI_MAX, MPI_COMM_WORLD );

    // Print answers, forcing output to follow rank order
    // (This is a bad way to do that, but it's short and simple...)
    for ( int step=0; step<size; step++ )
    {
        if ( step == rank )
        {
            printf ( "Rank %d\thas %d\tMax is %d\n", rank, number, max );
            fflush ( stdout );
        }
        // MPI_Barrier forces every process in the communicator to call it
        // before any of them can continue
        MPI_Barrier ( MPI_COMM_WORLD );
    }
    MPI_Finalize();
}
