#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <mpi.h>


int
main ( int argc, char **argv )
{
    int rank, size;
    MPI_Init ( &argc, &argv );
    MPI_Comm_rank ( MPI_COMM_WORLD, &rank );
    MPI_Comm_size ( MPI_COMM_WORLD, &size );

    /* Find maximum of P numbers */

    // Everyone pulls one number out of a hat
    srand(time(NULL)+rank);
    int number = rand();
    int max = 0;


    // Work out who my neighbors are
    int left  = (rank-1+size)%size,
        right = (rank+1)%size;

    // Pass values until everyone has seen them all
    for ( int step=0; step<size; step++ )
    {
        // Compare and keep largest number
        if ( number > max )
            max = number;

        // Pass this value on to right neighbor
        MPI_Send (
            &number, 1, MPI_INT, right, 0, MPI_COMM_WORLD
        );
        // Receive next value from left neighbor
        MPI_Recv (
            &number, 1, MPI_INT, left, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE
        );
    }

    // Print answers, forcing output to follow rank order
    // (This is a bad way to do that, but it's short and simple...)
    for ( int step=0; step<size; step++ )
    {
        if ( step == rank )
        {
            printf ( "Rank %d\thas %d\tMax is %d\n", rank, number, max );
            fflush ( stdout );
        }
        // MPI_Barrier forces every process in the communicator to call it
        // before any of them can continue
        MPI_Barrier ( MPI_COMM_WORLD );
    }
    MPI_Finalize();
}
