#include <iostream>
#include <chrono>

float slowFunction() {
	const unsigned long count = 500000000;
	long long sum = 0;

	for(long i = 0; i < count; i++) {
		long value = i % 5000;
		if(value > 4500) {
			sum += i;
		} else {
			sum -= i;
		}
	}
}

float fastFunction() {
	int k = 0;

	for(int i = 0 ; i < 1000000; i++) {
		k += i % 50;
	}
}



int main(int argc, char** argv) {

	auto start = std::chrono::high_resolution_clock::now();
	std::cout << slowFunction() << std::endl;
	auto end = std::chrono::high_resolution_clock::now();
	
	std::cout << "Execution took " << std::chrono::duration_cast<std::chrono::milliseconds>(end - start).count() << " ms" << std::endl;
	
	start = std::chrono::high_resolution_clock::now();
	std::cout << fastFunction() << std::endl;
	end = std::chrono::high_resolution_clock::now();
	
	std::cout << "Execution took " << std::chrono::duration_cast<std::chrono::milliseconds>(end - start).count() << " ms" << std::endl;

	return 0;
}