#version 430 core

in layout(location = 0) vec3 position;
in layout(location = 1) vec3 normal_in;
in layout(location = 2) vec2 texCoord_in;

in layout(location = 5) vec3 tangent;
in layout(location = 6) vec3 bitangent;

uniform layout(location = 3) mat4 MVP;
uniform layout(location = 4) mat4 modelMatrx;
uniform layout(location = 5) mat3 normalMatrix;

out layout(location = 1) vec4 fragCoordinate;
out layout(location = 2) vec2 texCoord_out;
out layout(location = 3) mat3 TBN;

void main()
{
    vec3 T = normalize(normalMatrix * tangent);
    vec3 B = normalize(normalMatrix * bitangent);
    vec3 N = normalize(normalMatrix * normal_in);
    TBN = mat3(T, B, N);

    texCoord_out = texCoord_in;
    fragCoordinate = modelMatrx * vec4(position, 1.0);
    gl_Position = MVP * vec4(position, 1.0f);
}
