#version 430 core

in layout(location = 0) vec3 normal;
in layout(location = 1) vec4 fragCoordinate;

uniform layout(location = 10) vec3 lightPosition;

const vec3 cameraLocation = vec3(0, 0, 0);

out vec4 color;

void main()
{
    vec3 normalisedNormal = normalize(normal);
    vec3 surfaceToLightVector = normalize(lightPosition - vec3(fragCoordinate));

    float distanceToLightSource = length(lightPosition - vec3(fragCoordinate));

    float diffuse = max(dot(normalisedNormal, surfaceToLightVector) / (0.2 * distanceToLightSource), 0);
    vec4 diffuseColour = vec4(diffuse, diffuse, diffuse, 1.0);

    vec3 surfaceToEyeVector = normalize(cameraLocation - vec3(fragCoordinate));
    float specular = pow(max(dot(surfaceToEyeVector, reflect(-surfaceToLightVector, normalisedNormal)), 0), 256);
    vec4 specularColour = specular * vec4(1.0, 1.0, 1.0, 1.0);

    color = diffuseColour + specularColour;
    //color.z = 0;
    //color.y = 0;
    //color = vec4(intensity, intensity, intensity, 1.0f);
}
