#version 430 core

in layout(location = 0) vec3 position;
in layout(location = 1) vec3 normal_in;

uniform layout(location = 3) mat4 MVP;
uniform layout(location = 4) mat4 modelMatrx;
uniform layout(location = 5) mat3 normalMatrix;

out layout(location = 0) vec3 normal_out;
out layout(location = 1) vec4 fragCoordinate;

void main()
{
    normal_out = normalize(normalMatrix * normal_in);
    fragCoordinate = modelMatrx * vec4(position, 1.0);
    gl_Position = MVP * vec4(position, 1.0f);
}
