# Version 1.1 Released {#version-1-1-released-2019-05-30}

_May 30, 2019_

We are proud to announce the release of version 1.1 of the Polygon Mesh
Processing Library! This minor release includes a couple new features,
enhancements, bug fixes, and updates to third-party libraries. Highlights
include:

- An implementation of the hole filling algorithm by Liepa[^1]
- An improved `SurfaceSmoothing` algorithm avoiding model shrinking[^2]
- A new compile-time switch to choose between `float` or `double` as default
  `Scalar` type
- Native support for high-DPI displays on all supported operating systems and
  browsers

This release also includes one breaking change encapsulating some public members
of the `Window` and `TrackballViewer` classes. While this change effectively
modifies the public API of the library, we felt that the change is too minor to
justify a bump of the major version number. See
this
[commit](https://github.com/pmp-library/pmp-library/commit/10d93fcf939869ea4732dff19d671831e78a5264) for
details and to check if you might be affected by it.

For this release, we also slightly changed the license terms to include an
explicit disclaimer excluding all present and previous employers from any
warranty and liability, see the
updated
[license](https://github.com/pmp-library/pmp-library/blob/master/LICENSE.txt)
text for details. The disclaimer does not change anything about what you can do
with the library. The license terms are still equivalent to those of the
original MIT license.

You can find a full summary of changes in the
[changelog](https://github.com/pmp-library/pmp-library/blob/master/CHANGELOG.md).

## Obtaining the pmp-library

Get your own copy by cloning:

```sh
git clone --recursive https://github.com/pmp-library/pmp-library.git
```

Checkout the 1.1 release tag:

```sh
cd pmp-library && git checkout 1.1.0
```

Configure and build:

```sh
mkdir build && cd build && cmake .. && make
```

Run the mesh processing app

```sh
./mpview ../external/pmp-data/off/bunny.off
```

## Reporting Bugs or Problems

If you encounter any glitches or problems
please [report the issue](https://github.com/pmp-library/pmp-library/issues) on
our GitHub issue tracker.

## References

[^1]: Peter Liepa. Filling holes in meshes. In _Proceedings of Eurographics Symposium on Geometry Processing_, pages 200–205, 2003.
[^2]: Misha Kazhdan, Justin Solomon, and Mirela Ben-Chen. _Can mean‐curvature flow be modified to be non‐singular?_ Computer Graphics Forum, 31(5), 2012.
