# Version 1.2 Released {#version-1-2-released-2020-03-15}

_Mar 15, 2020_

We are proud to announce the release of version 1.2 of the Polygon Mesh
Processing Library! This minor release includes a couple of new features,
enhancements, bug fixes, and updates to third-party libraries. Highlights
include:

- Improved rendering of general polygons, avoiding erroneous tessellation into
  overlapping/flipped triangles in case of non-convex polygons.
- Added support for rendering using matcaps.
- Eigen interoperability: Matrix and vector classes can now be assigned and cast
  from Eigen matrices and vectors.
- Matrix and vector classes can now be constructed using initializer lists.

You can find a full summary of changes in the
[changelog](https://github.com/pmp-library/pmp-library/blob/master/CHANGELOG.md).

## Matcap Rendering

The new matcap rendering is demonstrated in our mesh viewer application. `mview`
now takes an optional `-m` argument specifying the matcap to be used. We
included several example files in the
[pmp-data](https://github.com/pmp-library/pmp-data/) repository. See below for
an example using the following command line:

```sh
./mview -m ../external/pmp-data/matcap/metal_shiny.jpg ../external/pmp-data/off/bunny.off
```

![matcap](matcap.png)

## Improved Polygon Rendering

The improved polygon rendering is demonstrated best by an example. Before the
improvements the rendering of a mesh containing non-convex polygons could lead
to undesirable overlapping/flipped triangles:

![before](mview-before-poly-fix.png)

The improved version now renders the same mesh correctly:

![before](mview-after-poly-fix.png)

## Eigen Interoperability

This release also improves interoperability with the Eigen library. We added support to construct/assign pmp::Matrix and pmp::Vector classes from Eigen as well as support to cast the pmp::Matrix and pmp::Vector class to Eigen. Example for construction:

```cpp
// construction from Eigen
Eigen::Vector3d eigenVec(1.0, 2.0, 3.0);
pmp::dvec3 pmpVec = eigenVec;
```

Example for assignment:

```cpp
// assignment from Eigen
Eigen::Vector3d eigenVec(1.0, 2.0, 3.0);
pmp::dvec3 pmpVec;
pmpVec = eigenVec;
```

Example for cast:

```cpp
// cast to Eigen
pmp::vec3 pmpVec(1.0, 2.0, 3.0);
Eigen::Vector3f eigenVec = static_cast<Eigen::Vector3f>(pmpVec);
```

## Obtaining the pmp-library

Get your own copy by cloning:

```sh
git clone --recursive https://github.com/pmp-library/pmp-library.git
```

Checkout the 1.2 release tag:

```sh
cd pmp-library && git checkout 1.2.0
```

Configure and build:

```sh
mkdir build && cd build && cmake .. && make
```

Run the mesh processing app

```sh
./mpview ../external/pmp-data/off/bunny.off
```

## Reporting Bugs or Problems

If you encounter any glitches or problems
please [report the issue](https://github.com/pmp-library/pmp-library/issues) on
our GitHub issue tracker.
