// Documetation can be found at http://tdt4102.pages.stud.idi.ntnu.no/graph_lib/
/** 
 * @file
 * @brief File declaring the struct @c Point and overloading operators for @c Point
 */
#pragma once

namespace Graph_lib {
/** @brief A structure for representing a coordinatepoint used for Graphics */
struct Point
{
	int x;
	int y;
};

/**
 @brief Overloaded == operator for a @c Point. Returns True if both x and y coordinate of @p a and @p b are the same, False otherwise
 */
inline bool operator==(Point a, Point b)
{
	return a.x == b.x && a.y == b.y;
}

/**
 @brief Overloaded != operator for @c Point. Returns False if both x and y coordinate of @p a and @p b are the same, True otherwise
 */
inline bool operator!=(Point a, Point b)
{
	return !(a == b);
}

} // namespace Graph_lib
