// Documetation can be found at http://tdt4102.pages.stud.idi.ntnu.no/graph_lib/
/**
@file
@brief Made for simple interaction with graphics. Provides one window with one "next" button for simple animation
*/

#pragma once

#include "GUI.h" // for Simple_window only (doesn't really belong in Window.h)

using namespace Graph_lib;

/**
@brief Simple_window provides one window with one "next" button for ultra-simple animation */
struct Simple_window : Graph_lib::Window
{
    /**
     *@brief Initializes a Simple_Winow using Window constructor
     *@param xy Top left corner
     *@param w Width of window
     *@param h Height of window
     *@param title title to be displayed at top
     */
	Simple_window(Point xy, int w, int h, const string& title)
		: Window(xy, w, h, title),
		  next_button(Point{x_max() - 70, 0}, 70, 20, "Next", cb_next),
		  button_pushed(false)
	{
		attach(next_button);
	}
    /**
    @brief Modified event loop, handles all events and quits when button is pushed
    */
	void wait_for_button()
	// modified event loop
	// handle all events (as per default), but quit when button_pushed
	// becomes true this allows graphics without control inversion
	{
		while (!button_pushed)
			Fl::wait();
		button_pushed = false;
		Fl::redraw();
	}
	Button next_button;

private:
	bool button_pushed;

    /**
     @brief callback for @c next_button, will call @c next
     @param addr adress of Window
     */
    static void cb_next(Address, Address addr)
	// callback for next_button
	//{ reference_to<Simple_window>(addr).next(); }
	{
		static_cast<Simple_window *>(addr)->next();
	}

    /**
     @brief called by @c cb_next, will redraw or quit window
     */
	void next() { button_pushed = true; }
};
