// Documetation can be found at http://tdt4102.pages.stud.idi.ntnu.no/graph_lib/
/** 
 @file 
 @brief File for class Window used for displaying graphics
*/
#pragma once

#include "fltk.h"

#include "std_lib_facilities.h"

#include "Point.h"

namespace Graph_lib {

class Shape;	// "forward declare" Shape
class Widget;
/**
 @brief Class for creating simple graphics-windows
 */
class Window : public Fl_Double_Window {
public:
/**
    @brief Constructs Window, lets system pick location on screen
    @param w Width
    @param h Height
    @param title title to be displayed at top
    */
	Window(int w, int h, const string& title); // let the system pick the location

	/**
    @brief Constructs a Window
    @param xy Point of top left corner
    @param w Width
    @param h Height
    @param title Title to be displayed at top
    */
	Window(Point xy, int w, int h, const string& title);	// top left corner in xy
	virtual ~Window() { }

	/**
	@brief Returns width, maximum allowed x-value
	*/
	int x_max() const { return w; }

	/**
     @brief Returns height, maximum allowed y-value
     */
	int y_max() const { return h; }
	
    /**
     @brief Changes size of Window-object
     @param ww New width
     @param hh New height
     */

	void resize(int ww, int hh) { w=ww; h=hh; size(ww,hh); }
	using Fl_Double_Window::resize;

	void set_label(const string& s) { label(s.c_str()); }

	/**
     @brief Attaches a Shape @p s to the Window object, @p s will be shown in window
     @param s Reference to a Shape
     */
	void attach(Shape& s);
	
	/**
     @brief Attaches a Widget @p w to the Window, @p w will be shown in window
     @param w Reference to a Widget
     */
	void attach(Widget& w);

	/**
     @brief detaches @p s from Window, will not be displayed
     @param s reference to Shape
     */
	void detach(Shape& s);	// remove s from shapes
	
	/**
     @brief detaches @p w from window
     @param w reference to a widget
     */
	void detach(Widget& w);	// remove w from window (deactivate callbacks)
	
	/**
     @brief puts @p p on top of other shapes
     @param p reference to a shape
    */
	void put_on_top(Shape& p);	// put p on top of other shapes

	/** @brief Schedules redrawing of widget, as per FLTK docs*/
	void redraw() { Fl_Double_Window::redraw(); }
	// Schedules redrawing of widget, as per FLTK docs

protected:
	/** @brief Iterates through all elements in @c shapes and draws them on Window*/
	void draw();

private:
	int w, h;				// window size
	
	/** @brief vector containing all Shapes attached to Window */
	vector<Shape*> shapes;	// shapes attached to window

	/** @brief Displays Window on screen, called by constructor */
	void init();
};

/** @brief invokes GUI librarys main event loop */
int gui_main();	// invoke GUI library's main event loop

/** @brief returns width of screen in pixels */
inline int x_max() { return Fl::w(); } // returns width of screen in pixels

/** @brief returns width of screen in pixels */
inline int y_max() { return Fl::h(); } // returns width of screen in pixels
}
