#include "internal/KeyboardKeyConverter.h"
#include <unordered_map>
#include <string>
#include <stdexcept>

KeyboardKey TDT4102::internal::convertSDLKeyToKeyboardKey(SDL_Keysym key) {
    switch(key.sym) {
        case SDLK_UNKNOWN :
            return KeyboardKey::UNKNOWN;
        case SDLK_RETURN:
            return KeyboardKey::ENTER;
        case SDLK_ESCAPE:
            return KeyboardKey::ESCAPE;
        case SDLK_BACKSPACE:
            return KeyboardKey::BACKSPACE;
        case SDLK_TAB:
            return KeyboardKey::TAB;
        case SDLK_SPACE:
            return KeyboardKey::SPACE;
        case SDLK_EXCLAIM:
            return KeyboardKey::EXCLAMATION_MARK;
        case SDLK_QUOTEDBL:
            return KeyboardKey::DOUBLE_QUOTE;
        case SDLK_HASH:
            return KeyboardKey::HASH;
        case SDLK_PERCENT:
            return KeyboardKey::PERCENT;
        case SDLK_DOLLAR:
            return KeyboardKey::DOLLAR;
        case SDLK_AMPERSAND:
            return KeyboardKey::AMPERSAND;
        case SDLK_QUOTE:
            return KeyboardKey::QUOTE;
        case SDLK_LEFTPAREN:
            return KeyboardKey::LEFT_PAREN;
        case SDLK_RIGHTPAREN:
            return KeyboardKey::RIGHT_PAREN;
        case SDLK_ASTERISK:
            return KeyboardKey::ASTERISK;
        case SDLK_PLUS:
            return KeyboardKey::PLUS;
        case SDLK_COMMA:
            return KeyboardKey::COMMA;
        case SDLK_MINUS:
            return KeyboardKey::MINUS;
        case SDLK_PERIOD:
            return KeyboardKey::PERIOD;
        case SDLK_SLASH:
            return KeyboardKey::SLASH;
        case SDLK_0:
            return KeyboardKey::KEY_0;
        case SDLK_1:
            return KeyboardKey::KEY_1;
        case SDLK_2:
            return KeyboardKey::KEY_2;
        case SDLK_3:
            return KeyboardKey::KEY_3;
        case SDLK_4:
            return KeyboardKey::KEY_4;
        case SDLK_5:
            return KeyboardKey::KEY_5;
        case SDLK_6:
            return KeyboardKey::KEY_6;
        case SDLK_7:
            return KeyboardKey::KEY_7;
        case SDLK_8:
            return KeyboardKey::KEY_8;
        case SDLK_9:
            return KeyboardKey::KEY_9;
        case SDLK_COLON:
            return KeyboardKey::COLON;
        case SDLK_SEMICOLON:
            return KeyboardKey::SEMICOLON;
        case SDLK_LESS:
            return KeyboardKey::LESS_THAN;
        case SDLK_EQUALS:
            return KeyboardKey::EQUALS;
        case SDLK_GREATER:
            return KeyboardKey::GREATER_THAN;
        case SDLK_QUESTION:
            return KeyboardKey::QUESTION_MARK;
        case SDLK_AT:
            return KeyboardKey::AT;
        case SDLK_LEFTBRACKET:
            return KeyboardKey::LEFT_BRACKET;
        case SDLK_BACKSLASH:
            return KeyboardKey::BACKSLASH;
        case SDLK_RIGHTBRACKET:
            return KeyboardKey::RIGHT_BRACKET;
        case SDLK_CARET:
            return KeyboardKey::CARET;
        case SDLK_UNDERSCORE:
            return KeyboardKey::UNDERSCORE;
        case SDLK_BACKQUOTE:
            return KeyboardKey::GRAVE;
        case SDLK_a:
            return KeyboardKey::A;
        case SDLK_b:
            return KeyboardKey::B;
        case SDLK_c:
            return KeyboardKey::C;
        case SDLK_d:
            return KeyboardKey::D;
        case SDLK_e:
            return KeyboardKey::E;
        case SDLK_f:
            return KeyboardKey::F;
        case SDLK_g:
            return KeyboardKey::G;
        case SDLK_h:
            return KeyboardKey::H;
        case SDLK_i:
            return KeyboardKey::I;
        case SDLK_j:
            return KeyboardKey::J;
        case SDLK_k:
            return KeyboardKey::K;
        case SDLK_l:
            return KeyboardKey::L;
        case SDLK_m:
            return KeyboardKey::M;
        case SDLK_n:
            return KeyboardKey::N;
        case SDLK_o:
            return KeyboardKey::O;
        case SDLK_p:
            return KeyboardKey::P;
        case SDLK_q:
            return KeyboardKey::Q;
        case SDLK_r:
            return KeyboardKey::R;
        case SDLK_s:
            return KeyboardKey::S;
        case SDLK_t:
            return KeyboardKey::T;
        case SDLK_u:
            return KeyboardKey::U;
        case SDLK_v:
            return KeyboardKey::V;
        case SDLK_w:
            return KeyboardKey::W;
        case SDLK_x:
            return KeyboardKey::X;
        case SDLK_y:
            return KeyboardKey::Y;
        case SDLK_z:
            return KeyboardKey::Z;
        case SDLK_CAPSLOCK:
            return KeyboardKey::CAPS_LOCK;
        case SDLK_F1:
            return KeyboardKey::F1;
        case SDLK_F2:
            return KeyboardKey::F2;
        case SDLK_F3:
            return KeyboardKey::F3;
        case SDLK_F4:
            return KeyboardKey::F4;
        case SDLK_F5:
            return KeyboardKey::F5;
        case SDLK_F6:
            return KeyboardKey::F6;
        case SDLK_F7:
            return KeyboardKey::F7;
        case SDLK_F8:
            return KeyboardKey::F8;
        case SDLK_F9:
            return KeyboardKey::F9;
        case SDLK_F10:
            return KeyboardKey::F10;
        case SDLK_F11:
            return KeyboardKey::F11;
        case SDLK_F12:
            return KeyboardKey::F12;
        case SDLK_PRINTSCREEN:
            return KeyboardKey::PRINT_SCREEN;
        case SDLK_SCROLLLOCK:
            return KeyboardKey::SCROLL_LOCK;
        case SDLK_PAUSE:
            return KeyboardKey::PAUSE;
        case SDLK_INSERT:
            return KeyboardKey::INSERT;
        case SDLK_HOME:
            return KeyboardKey::HOME;
        case SDLK_PAGEUP:
            return KeyboardKey::PAGE_UP;
        case SDLK_DELETE:
            return KeyboardKey::DELETE;
        case SDLK_END:
            return KeyboardKey::END;
        case SDLK_PAGEDOWN:
            return KeyboardKey::PAGE_DOWN;
        case SDLK_RIGHT:
            return KeyboardKey::RIGHT;
        case SDLK_LEFT:
            return KeyboardKey::LEFT;
        case SDLK_DOWN:
            return KeyboardKey::DOWN;
        case SDLK_UP:
            return KeyboardKey::UP;
        case SDLK_NUMLOCKCLEAR:
            return KeyboardKey::NUM_LOCK;
        case SDLK_KP_DIVIDE:
            return KeyboardKey::NUMPAD_SLASH;
        case SDLK_KP_MULTIPLY:
            return KeyboardKey::NUMPAD_ASTERISK;
        case SDLK_KP_MINUS:
            return KeyboardKey::NUMPAD_MINUS;
        case SDLK_KP_PLUS:
            return KeyboardKey::NUMPAD_PLUS;
        case SDLK_KP_ENTER:
            return KeyboardKey::NUMPAD_ENTER;
        case SDLK_KP_1:
            return KeyboardKey::NUMPAD_1;
        case SDLK_KP_2:
            return KeyboardKey::NUMPAD_2;
        case SDLK_KP_3:
            return KeyboardKey::NUMPAD_3;
        case SDLK_KP_4:
            return KeyboardKey::NUMPAD_4;
        case SDLK_KP_5:
            return KeyboardKey::NUMPAD_5;
        case SDLK_KP_6:
            return KeyboardKey::NUMPAD_6;
        case SDLK_KP_7:
            return KeyboardKey::NUMPAD_7;
        case SDLK_KP_8:
            return KeyboardKey::NUMPAD_8;
        case SDLK_KP_9:
            return KeyboardKey::NUMPAD_9;
        case SDLK_KP_0:
            return KeyboardKey::NUMPAD_0;
        case SDLK_KP_PERIOD:
            return KeyboardKey::NUMPAD_PERIOD;

        case SDLK_F13:
            return KeyboardKey::F13;
        case SDLK_F14:
            return KeyboardKey::F14;
        case SDLK_F15:
            return KeyboardKey::F15;
        case SDLK_F16:
            return KeyboardKey::F16;
        case SDLK_F17:
            return KeyboardKey::F17;
        case SDLK_F18:
            return KeyboardKey::F18;
        case SDLK_F19:
            return KeyboardKey::F19;
        case SDLK_F20:
            return KeyboardKey::F20;
        case SDLK_F21:
            return KeyboardKey::F21;
        case SDLK_F22:
            return KeyboardKey::F22;
        case SDLK_F23:
            return KeyboardKey::F23;
        case SDLK_F24:
            return KeyboardKey::F24;
        case SDLK_MUTE:
            return KeyboardKey::AUDIO_MUTE;
        case SDLK_VOLUMEUP:
            return KeyboardKey::AUDIO_VOLUME_UP;
        case SDLK_VOLUMEDOWN:
            return KeyboardKey::AUDIO_VOLUME_DOWN;
        case SDLK_KP_COMMA:
            return KeyboardKey::NUMPAD_COMMA;
        case SDLK_LCTRL:
            return KeyboardKey::LEFT_CTRL;
        case SDLK_LSHIFT:
            return KeyboardKey::LEFT_SHIFT;
        case SDLK_LALT:
            return KeyboardKey::LEFT_ALT;
        case SDLK_LGUI:
            return KeyboardKey::SUPER_LEFT;
        case SDLK_RCTRL:
            return KeyboardKey::RIGHT_CTRL;
        case SDLK_RSHIFT:
            return KeyboardKey::RIGHT_SHIFT;
        case SDLK_RALT:
            return KeyboardKey::RIGHT_ALT;
        case SDLK_RGUI:
            return KeyboardKey::SUPER_RIGHT;
        case SDLK_KP_EQUALS:
            return KeyboardKey::NUMPAD_EQUALS;

        case SDLK_AUDIONEXT:
            return KeyboardKey::AUDIO_NEXT;
        case SDLK_AUDIOPREV:
            return KeyboardKey::AUDIO_PREV;
        case SDLK_AUDIOSTOP:
            return KeyboardKey::AUDIO_STOP;
        case SDLK_AUDIOPLAY:
            return KeyboardKey::AUDIO_PLAY;
        case SDLK_AUDIOMUTE:
            return KeyboardKey::AUDIO_MUTE;


            // Unsupported keys
        case SDLK_KP_EQUALSAS400:
        case SDLK_ALTERASE:
        case SDLK_SYSREQ:
        case SDLK_CANCEL:
        case SDLK_CLEAR:
        case SDLK_PRIOR:
        case SDLK_RETURN2:
        case SDLK_SEPARATOR:
        case SDLK_OUT:
        case SDLK_OPER:
        case SDLK_CLEARAGAIN:
        case SDLK_CRSEL:
        case SDLK_EXSEL:
        case SDLK_KP_00:
        case SDLK_KP_000:
        case SDLK_THOUSANDSSEPARATOR:
        case SDLK_DECIMALSEPARATOR:
        case SDLK_CURRENCYUNIT:
        case SDLK_CURRENCYSUBUNIT:
        case SDLK_KP_LEFTPAREN:
        case SDLK_KP_RIGHTPAREN:
        case SDLK_KP_LEFTBRACE:
        case SDLK_KP_RIGHTBRACE:
        case SDLK_KP_TAB:
        case SDLK_KP_BACKSPACE:
        case SDLK_KP_A:
        case SDLK_KP_B:
        case SDLK_KP_C:
        case SDLK_KP_D:
        case SDLK_KP_E:
        case SDLK_KP_F:
        case SDLK_KP_XOR:
        case SDLK_KP_POWER:
        case SDLK_KP_PERCENT:
        case SDLK_KP_LESS:
        case SDLK_KP_GREATER:
        case SDLK_KP_AMPERSAND:
        case SDLK_KP_DBLAMPERSAND:
        case SDLK_KP_VERTICALBAR:
        case SDLK_KP_DBLVERTICALBAR:
        case SDLK_KP_COLON:
        case SDLK_KP_HASH:
        case SDLK_KP_SPACE:
        case SDLK_KP_AT:
        case SDLK_KP_EXCLAM:
        case SDLK_KP_MEMSTORE:
        case SDLK_KP_MEMRECALL:
        case SDLK_KP_MEMCLEAR:
        case SDLK_KP_MEMADD:
        case SDLK_KP_MEMSUBTRACT:
        case SDLK_KP_MEMMULTIPLY:
        case SDLK_KP_MEMDIVIDE:
        case SDLK_KP_PLUSMINUS:
        case SDLK_KP_CLEAR:
        case SDLK_KP_CLEARENTRY:
        case SDLK_KP_BINARY:
        case SDLK_KP_OCTAL:
        case SDLK_KP_DECIMAL:
        case SDLK_KP_HEXADECIMAL:
        case SDLK_EXECUTE:
        case SDLK_HELP:
        case SDLK_MENU:
        case SDLK_MODE:
        case SDLK_SELECT:
        case SDLK_STOP:
        case SDLK_AGAIN:
        case SDLK_UNDO:
        case SDLK_CUT:
        case SDLK_COPY:
        case SDLK_PASTE:
        case SDLK_FIND:
        case SDLK_APPLICATION:
        case SDLK_POWER:
        case SDLK_MEDIASELECT:
        case SDLK_WWW:
        case SDLK_MAIL:
        case SDLK_CALCULATOR:
        case SDLK_COMPUTER:
        case SDLK_AC_SEARCH:
        case SDLK_AC_HOME:
        case SDLK_AC_BACK:
        case SDLK_AC_FORWARD:
        case SDLK_AC_STOP:
        case SDLK_AC_REFRESH:
        case SDLK_AC_BOOKMARKS:
        case SDLK_BRIGHTNESSDOWN:
        case SDLK_BRIGHTNESSUP:
        case SDLK_DISPLAYSWITCH:
        case SDLK_KBDILLUMTOGGLE:
        case SDLK_KBDILLUMDOWN:
        case SDLK_KBDILLUMUP:
        case SDLK_EJECT:
        case SDLK_SLEEP:
        case SDLK_APP1:
        case SDLK_APP2:
        case SDLK_AUDIOREWIND:
        case SDLK_AUDIOFASTFORWARD:
            return KeyboardKey::UNKNOWN;

        default:
            throw std::runtime_error("Unknown SDL key detected: " + std::string(SDL_GetKeyName(key.sym)));
    }
}
